#version 120
varying vec4 texcoord;
varying vec4 color;

uniform mat4 gbufferModelView;
uniform mat4 gbufferModelViewInverse;

float curve(float x)
{
	return tan(x);
}

float invcurve(float x, float curvature)
{
	return atan(x/curvature)*curvature;
}

void main() {
	vec4 position = gl_ModelViewMatrix * gl_Vertex;

	position = gbufferModelViewInverse * position;

	float curvature = 256;

	float dist = sqrt(position.z*position.z + position.x*position.x);

	float oma = curve(dist / curvature);
	float y = position.y;
	float z = invcurve(position.z, curvature);
	float x = invcurve(position.x, curvature);
	float xy = invcurve(dist, curvature);
	position.y = (xy*oma+y);
	position.x = x;
	position.z = z;

	position = gbufferModelView * position;

	gl_Position = gl_ProjectionMatrix * position;

	color = gl_Color;

	texcoord = gl_MultiTexCoord0;
}
